
IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_TRILHO_EXCESSO]')
          AND type IN(N'P', N'PC')
)
    DROP PROCEDURE [dbo].[P_TRILHO_EXCESSO];
GO
 
SET ANSI_NULLS ON;
GO
SET QUOTED_IDENTIFIER ON;
GO
/*
=======================================================================================
'Job.................: Linx - Trilho de envio de excesso 
'Função..............: 
'Objetivo............: Gerar pre fatura
'Tabelas.............: 
'Dt Modificação......: 04/06/2021
'Modificação.........: Tag #A001 Só gerar pedido EST_PED_VD se valor total for acima do limite configurado para maquina. 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
--EXEC P_TRILHO_EXCESSO 1,0
CREATE PROCEDURE [dbo].[P_TRILHO_EXCESSO] @CD_EMP INT = 1, 
                                          @TP_PED INT = 0
WITH ENCRYPTION
AS
    BEGIN
        SET NOCOUNT ON;
        
		DECLARE @combinacaoRealizada TABLE(FILIAL_ORIG INT, FILIAL_DEST INT);

        DECLARE @filial TABLE(CD_FILIAL      INT, 
								CD_AGENDA      INT, 
								QT_LIMITE_DEST INT DEFAULT 0, 
								QT_LIMITE_ORIG INT DEFAULT 999,
								PRIMARY KEY(CD_FILIAL, CD_AGENDA));

        DECLARE @mensagemErro VARCHAR(255), @severidadeErro INT, @estadoErro INT;
        DECLARE @CONTADOR INT, 
				@CD_MAQUINA INT, 
				@CD_AGENDA INT, 
				@TRILHOS INT, 
				@DT_HOJE DATETIME, 
				@DT_VALIDADE DATETIME, 
				@CD_PED INT, 
				@FILIAL_ORIG INT, 
				@FILIAL_DEST INT, 
				@VLR_ATEND MONEY, 
				@CD_NT_MOV_GRP_ECON INT, 
				@CD_NT_MOV_GRP_ECON_EMP INT, 
				@CD_NT_MOV_GRP_LJ INT, 
				@CD_NT_MOV INT, 
				@CD_TRILHO INT, 
				@QT_LIMITE_DEST INT, 
				@LINHAS INT, 
				@FLAG_QUEBRA TINYINT, 
				@Cmd VARCHAR(1000), 
				@UF_ORIG VARCHAR(2), @nTop INT;


        IF OBJECT_ID('TEMPDB.dbo.#RsItem') IS NOT NULL
            BEGIN
                DROP TABLE #RsItem;
            END;

        CREATE TABLE #RsItem (CD_EMP         INT, 
							 CD_FILIAL_DEST INT, 
							 CD_FILIAL_ORIG INT, 
							 CD_PROD        INT, 
							 QTDE_PROD      MONEY, 
							 CD_BENEF       VARCHAR(10));

        --Testando se tem a natureza de vendas cadastrada
        SET @CD_NT_MOV_GRP_ECON_EMP = ISNULL((SELECT TOP 1 CD_MOV_OP
														FROM GLB_MOV_OP
														WHERE TP_MOV_OP_TRANSA = 1
															  AND TP_MOV = 0
															  AND DEST_ORIG = 0
															  AND BX_EST = 1
															  AND STS_MOV = 0), 0);

        -- Verificar a viabiliadade de buscar do parametro filial 'CD_MOV_OP_VENDA_GRP_ECON'
        PRINT 'P_TRILHO_EXCESSO  ' + CONVERT(VARCHAR, GETDATE(), 108);
        IF @CD_NT_MOV_GRP_ECON_EMP = 0
            BEGIN
                IF EXISTS(SELECT 1
								FROM prc_grp_econ e
									 INNER JOIN prc_grp_econ_prc_filial f ON e.cd_grp_econ = f.cd_filial
								WHERE e.STS_GRP_ECON = 0
								HAVING COUNT(*) > 1)
                    BEGIN
                        PRINT 'Natureza de movimentacao de venda nao encontrada ' + CONVERT(VARCHAR, GETDATE(), 108);
                        INSERT INTO ADM_ERRO(numero, 
											 severidade, 
											 estado, 
											 rotina, 
											 linha, 
											 mensagem, 
											 dtErro)
                        SELECT 0 AS numero, 
                                0 AS severidade, 
                                0 AS estado, 
                                'P_TRILHO_EXCESSO' AS rotina, 
                                0 AS linha, 
                                'Natureza de movimentacao de venda nao encontrada' AS mensagem, 
                                GETDATE() AS dtErro;
                        RETURN;
                    END;
                    ELSE
                    BEGIN
                        SET @CD_NT_MOV_GRP_ECON_EMP = -1; -- nao utiliza grupo economico
                    END;
            END;

        --Testando se tem a natureza de transferencia cadastrada
        SET @CD_NT_MOV = ISNULL((SELECT TOP 1 CD_MOV_OP
										FROM GLB_MOV_OP
										WHERE TP_MOV_OP_TRANSA = 1
											  AND TP_MOV = 10
											  AND BX_EST = 1
											  AND STS_MOV = 0), 0);
        IF @CD_NT_MOV = 0
            BEGIN
                PRINT 'Testando se tem a natureza de transferencia cadastrada ' + CONVERT(VARCHAR, GETDATE(), 108);
                INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
                SELECT 0 AS numero, 
                        0 AS severidade, 
                        0 AS estado, 
                        'P_TRILHO_EXCESSO' AS rotina, 
                        113 AS linha, 
                        'Natureza de movimentacao de transferencia nao encontrada ' AS mensagem, 
                        GETDATE() AS dtErro;
                RETURN;
            END;

        DECLARE @DIAS_RES_ACRESCENTAR INT;
        SET @DIAS_RES_ACRESCENTAR = ISNULL((SELECT DIAS_RES_ACRESCENTAR FROM PRC_EMP WHERE CD_EMP = @CD_EMP ), 0);

        DECLARE @DIAS_VENCTO_TRILHO TINYINT;
        SET @DIAS_VENCTO_TRILHO = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'QTDE_DIAS_VENCTO_PRE_FATURA_TRILHO'), 5);
        
		IF @TP_PED = 0
            BEGIN
                SELECT @DT_HOJE = dbo.F_HOJE(), 
                       @DT_VALIDADE = DATEADD(DAY, @DIAS_VENCTO_TRILHO, @DT_HOJE);
            END;
            ELSE
            BEGIN
                SELECT @DT_HOJE = dbo.F_HOJE() + @DIAS_RES_ACRESCENTAR, 
                       @DT_VALIDADE = DATEADD(DAY, 5, @DT_HOJE);
            END;
        
		PRINT 'Buscando os trilhos para o cursor na data de hoje ' + CONVERT(VARCHAR, GETDATE(), 108);
        --Buscando os trilhos para o cursor na data de hoje
        DECLARE cursorTrilhos CURSOR FOR 
			SELECT TRILHO.CD_TRILHO, 
				TRILHO.QT_LIMITE_DEST, 
				TRILHO_AGENDA.CD_TRILHO_AGENDA, 
				EST_EXCESSO_MAQ_TRILHO.CD_EXCESSO_MAQ
			FROM TRILHO
				INNER JOIN TRILHO_AGENDA ON TRILHO.CD_TRILHO = TRILHO_AGENDA.CD_TRILHO
				INNER JOIN EST_EXCESSO_MAQ_TRILHO ON TRILHO.CD_TRILHO = EST_EXCESSO_MAQ_TRILHO.CD_TRILHO
				INNER JOIN EST_EXCESSO_MAQ M ON EST_EXCESSO_MAQ_TRILHO.CD_EMP = M.CD_EMP
												AND EST_EXCESSO_MAQ_TRILHO.CD_EXCESSO_MAQ = M.CD_EXCESSO_MAQ
			WHERE TRILHO.CD_EMP = @CD_EMP
				AND TRILHO.STATUS = 0
				AND M.STATUS = 0
				AND (CASE WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 1 THEN DOMINGO
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 2 THEN SEGUNDA
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 3 THEN TERCA
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 4 THEN QUARTA 
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 5 THEN QUINTA 
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 6 THEN SEXTA 
						WHEN(DATEPART(WEEKDAY, @DT_HOJE)) = 7 THEN SABADO
					END) = 1
				AND ISNULL(M.TP_MAQ, 0) = 0
				AND M.TP_REDIRECIONAMENTO = @TP_PED;

        OPEN cursorTrilhos;
        FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_DEST, @CD_AGENDA, @CD_MAQUINA;
        WHILE @@FETCH_STATUS = 0
            BEGIN
                PRINT 'Remove TRILHO_MAQ_EXCESSO sem execesso ' + CONVERT(VARCHAR, GETDATE(), 108);
                DELETE FROM TRILHO_MAQ_EXCESSO
                WHERE CD_EXCESSO_MAQ = @CD_MAQUINA
                      AND (DT_MOV = DBO.F_HOJE()
                           OR DATEDIFF(DAY, DT_MOV, GETDATE()) > 15)
                      AND (EXCESSO < 1);
                PRINT 'Popula as filiais passiveis de participarem no trilho ' + CONVERT(VARCHAR, GETDATE(), 108);
                --Popula as filiais passiveis de participarem no trilho
                DELETE FROM @filial;
                INSERT INTO @filial(CD_FILIAL, CD_AGENDA, QT_LIMITE_DEST, QT_LIMITE_ORIG)

                SELECT CD_FILIAL, 
                        CD_TRILHO_AGENDA, 
                        QT_LIMITE_DEST = @QT_LIMITE_DEST, 
                        QT_LIMITE_ORIG = 999
                FROM TRILHO_PRC_FILIAL
                WHERE CD_EMP = @CD_EMP
                        AND CD_TRILHO = @CD_TRILHO
                        AND CD_TRILHO_AGENDA = @CD_AGENDA;

                SELECT @CONTADOR = 1, 
                       @TRILHOS = 0;

                SELECT @TRILHOS = COUNT(CD_FILIAL) FROM  UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA) WHERE  CD_TRILHO = @CD_TRILHO;

                IF @TRILHOS IS NULL OR @TRILHOS = 0
                    BEGIN
                        FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_DEST, @CD_AGENDA, @CD_MAQUINA;
                        CONTINUE;
                    END;

				DECLARE cOrigemDest CURSOR FOR 
				SELECT DISTINCT FILIAL_ORIG, 
								FILIAL_DEST, 
								VLR_ATEND
				FROM V_TRILHO_PROD_NECESSIDADE_ATENDIMENTO A
						INNER JOIN UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA) B ON A.FILIAL_ORIG = B.CD_FILIAL
						INNER JOIN EST_EXCESSO_MAQ C ON A.CD_EMP = C.CD_EMP
														AND A.CD_EXCESSO_MAQ = C.CD_EXCESSO_MAQ
						CROSS APPLY( SELECT * FROM DBO.UFD_TRILHO_EXCESSO(A.CD_EMP, FILIAL_ORIG, FILIAL_DEST, 0)) D
				WHERE A.CD_EMP = @CD_EMP
						AND B.CD_TRILHO = @CD_TRILHO
						AND A.CD_EXCESSO_MAQ = @CD_MAQUINA
						AND A.CD_EXCESSO_MAQ = D.CD_EXCESSO_MAQ
						AND VLR_ATEND > C.VLR_LIMITE_TRANSF
						AND FILIAL_ORIG <> FILIAL_DEST
						AND FILIAL_ORIG IN( SELECT CD_FILIAL FROM UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA) 
											WHERE EXISTS(SELECT * FROM @filial 
															WHERE CD_FILIAL = FILIAL_ORIG AND QT_LIMITE_DEST > 0)
													AND ENVIA = 1
													AND CD_TRILHO = B.CD_TRILHO)
					AND FILIAL_DEST IN( SELECT CD_FILIAL
										FROM UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA)
										WHERE EXISTS(SELECT * FROM @filial
															WHERE CD_FILIAL = FILIAL_DEST AND QT_LIMITE_ORIG > 0)
												AND RECEBE = 1
												AND CD_TRILHO = B.CD_TRILHO
												AND ORDEM >= B.ORDEM)
				ORDER BY VLR_ATEND DESC;
				OPEN cOrigemDest;
				FETCH NEXT FROM cOrigemDest INTO  @FILIAL_ORIG, @FILIAL_DEST, @VLR_ATEND; 
				WHILE @@FETCH_STATUS = 0
             
                    BEGIN
                        PRINT 'Selecina filial Origem: '  +CONVERT(VARCHAR,@FILIAL_ORIG) + ' --> Destino ' +convert(varchar, @FILIAL_DEST) +' - Time: '+ CONVERT(VARCHAR, GETDATE(), 108);

                        SET @CD_NT_MOV_GRP_ECON = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG WHERE CD_CHAVE = 'CD_MOV_OP_VENDA_GRP_ECON' AND CD_FILIAL = @FILIAL_ORIG ), 0);
                        IF @CD_NT_MOV_GRP_ECON = 0 --SE NAO TEM CONFIG. ESPECIFICA NA FILIAL
                            BEGIN
                                SET @CD_NT_MOV_GRP_ECON = @CD_NT_MOV_GRP_ECON_EMP;
                            END;
                        
						PRINT 'Seta limite de destinos - Orig.: ' + CONVERT(VARCHAR, @FILIAL_ORIG) + ' - ' + CONVERT(VARCHAR, GETDATE(), 108);
                        UPDATE @filial
                        SET  QT_LIMITE_DEST = QT_LIMITE_DEST - 1
                        WHERE CD_FILIAL = @FILIAL_ORIG;

                        PRINT 'Seta limite de Origem - Dest.: ' + CONVERT(VARCHAR, @FILIAL_DEST) + ' - ' + CONVERT(VARCHAR, GETDATE(), 108);
                        UPDATE @filial
                        SET QT_LIMITE_ORIG = QT_LIMITE_ORIG - 1
                        WHERE CD_FILIAL = @FILIAL_DEST;

                        SET @UF_ORIG = ISNULL((SELECT UF  FROM GLB_CID C
														JOIN PRC_FILIAL F ON C.CD_CID = F.CD_CID
													WHERE F.CD_EMP = @CD_EMP AND CD_FILIAL = @FILIAL_ORIG), 'ND');
                        IF(SELECT cd_grp_econ
                            FROM PRC_GRP_ECON_PRC_FILIAL
                            WHERE cd_filial = @FILIAL_ORIG) <>(SELECT cd_grp_econ
																	FROM PRC_GRP_ECON_PRC_FILIAL
																	WHERE cd_filial = @FILIAL_DEST)-- Se tem grupo economico
                            BEGIN
                                IF @CD_NT_MOV_GRP_ECON = 0
                                    BEGIN
                                        FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_DEST, @CD_AGENDA, @CD_MAQUINA;
                                        BREAK;
                                    END;
                            END;

                        IF @LINHAS = 0
                            BEGIN
                                FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_DEST, @CD_AGENDA, @CD_MAQUINA;
                                BREAK;
                            END;

                        -------------- QUEBRA PEDIDO --------------
                        SET @FLAG_QUEBRA = 1;
                        WHILE @FLAG_QUEBRA = 1
                            BEGIN
                                IF @TP_PED = 0  -- VERIFICA SE ? RESSUPRIMENTO OU PRE FATURA
                                    BEGIN 
                                        ------------------------------- RETORNA O CODIGO DO PEDIDO A SER INSERIDO -------------------------------------------
                                        SET @CD_PED = ISNULL(( SELECT MAX(CD_PED) FROM EST_PED_VD WITH(XLOCK)
																WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @FILIAL_ORIG), 0) + 1;
                                        --------------------------------------INSERE O CABECALHO DA VENDA ---------------------------------------------------
                                        --Inserindo itens para abatimento posterior
                                        PRINT '--Limpando a tabela temporaria #RsItem ' + CONVERT(VARCHAR, GETDATE(), 108);
                                        TRUNCATE TABLE #RsItem; --Limpando a tabela temporaria

                                        SELECT @nTop = QT_IT_NF FROM prc_filial WHERE cd_emp = @cd_emp AND cd_filial = @FILIAL_ORIG;
                                        IF ISNULL(@nTop, 0) < 1
                                            SET @nTop = 70;

                                        INSERT INTO #RsItem
                                        SELECT TOP (@nTop) @CD_EMP, 
                                                            @FILIAL_DEST, 
                                                            @FILIAL_ORIG, 
                                                            b.CD_PROD, 
                                                            b.QTDE_ATEND, 
                                                            F.CD_BENEF
                                        FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                            INNER JOIN EST_PROD P ON b.CD_EMP = p.CD_EMP
                                                                        AND b.CD_PROD = p.CD_PROD
                                            LEFT JOIN EST_PROD_COD_BENEF F ON P.CD_EMP = F.CD_EMP
                                                                                AND P.CD_PROD = F.CD_PROD
                                                                                AND F.UF = @UF_ORIG
                                        WHERE b.QTDE_ATEND > 0
                                                AND b.CD_EXCESSO_MAQ = @CD_MAQUINA
                                        ORDER BY p.DS_PROD;

                                        IF NOT EXISTS( SELECT * FROM #RsItem ) --PULA PARA PROXIMO PEDIDO
                                            BEGIN
                                                SET @FLAG_QUEBRA = 0;
                                                BREAK;
                                            END;


                                        PRINT 'Gerando a EST_PED_VD Pedido ' + CONVERT(VARCHAR, @CD_PED) + ' Na filial :' + CONVERT(VARCHAR, @FILIAL_ORIG) + ' Para lj :' + CONVERT(VARCHAR, @FILIAL_DEST) + ' Maquina :' + CONVERT(VARCHAR, @CD_MAQUINA) + ' - ' + CONVERT(VARCHAR, GETDATE(), 108);
                                        ;WITH BASE2
                                             AS (SELECT b.CD_EMP, 
                                                        b.CD_FILIAL_ORIG, 
                                                        b.CD_FILIAL_DEST, 
                                                        VLR_TOT_PROD = SUM(b.QTDE_ATEND * b.VLR_CUSTO)
                                                 FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                                      INNER JOIN #RsItem t ON b.CD_EMP = t.CD_EMP
                                                                              AND b.CD_FILIAL_ORIG = t.CD_FILIAL_ORIG
                                                                              AND b.CD_PROD = t.CD_PROD
                                                 WHERE b.CD_EXCESSO_MAQ = @CD_MAQUINA
                                                 GROUP BY b.CD_EMP, 
                                                          b.CD_FILIAL_ORIG, 
                                                          b.CD_FILIAL_DEST)
--Tag #A001
                                            INSERT INTO EST_PED_VD(CD_EMP, CD_FILIAL, CD_PED, CD_CLI, CD_VEND, 
																	  CD_NT_MOV, DT_EMI_PED, DT_CAD, VLR_TOT_PROD, VLR_TOT_PED, CD_COND_PGTO, 
																	  NM_COMPRADOR, NM_TRANSP, FRETE, OBS, CD_USU, STS_PED, DT_FAT, VLR_DESC, 
																	  DT_VALID, DT_ULT_ATU, DT_BX, TP_BX, HORA_CAD, TP_PED, VLR_FRETE, OBS_NF1, 
																	  OBS_NF2, PRZ_ENTRG, PRZ_VLD, COB, BLOQ_FATURAMENTO, VERSAO_APLICATIVO, APLICATIVO, NM_FRM)
											SELECT CD_EMP = @CD_EMP, 
                                                    CD_FILIAL = @FILIAL_ORIG, 
                                                    CD_PED = @CD_PED, 
                                                    CD_CLI = CASE
                                                                WHEN eo.CD_GRP_ECON <> ed.CD_GRP_ECON
                                                                THEN cd.CD_CLI
                                                                ELSE fd.CD_FILIAL
                                                            END, 
                                                    CD_VEND = 0, 
                                                    CD_NT_MOV = CASE
                                                                    WHEN eo.CD_GRP_ECON <> ed.CD_GRP_ECON
                                                                    THEN @CD_NT_MOV_GRP_ECON
                                                                    ELSE @CD_NT_MOV
                                                                END, 
                                                    DT_EMI_PED = @DT_HOJE, 
                                                    DT_CAD = @DT_HOJE, 
                                                    b.VLR_TOT_PROD, 
                                                    VLR_TOT_PED = b.VLR_TOT_PROD, 
                                                    CD_COND_PGTO = 0, 
                                                    NM_COMPRADOR = NULL, 
                                                    NM_TRASNP = NULL, 
                                                    FRETE = 9, 
                                                    OBS = NULL, 
                                                    CD_USU = 1, 
                                                    STS_PED = 0, 
                                                    DT_FAT = NULL, 
                                                    VLR_DESC = 0, 
                                                    DT_VALID = @DT_VALIDADE, 
                                                    DT_ULT_ATU = NULL, 
                                                    DT_BX = NULL, 
                                                    TP_BX = 0, 
                                                    HORA_CAD = NULL, 
                                                    TP_PED = 5, 
                                                    VLR_FRETE = 0, 
                                                    OBS_NF1 = NULL, 
                                                    OBS_NF2 = NULL, 
                                                    PRZ_ENTRG = 0, 
                                                    PRZ_VLD = 0, 
                                                    COB = 0, 
                                                    BLOQ_FATURAMENTO = 1, 
                                                    'Job Trilho Maq.:' + CONVERT(VARCHAR(6), @CD_MAQUINA), 
                                                    'P_TRILHO_EXCESSO', 
                                                    'P_TRILHO_EXCESSO Maq ' + CONVERT(VARCHAR(6), @CD_MAQUINA) NM_FRM
                                            FROM BASE2 b
                                                    INNER JOIN PRC_FILIAL fo ON b.CD_EMP = fo.CD_EMP
                                                                                AND b.CD_FILIAL_ORIG = fo.CD_FILIAL
                                                    INNER JOIN PRC_GRP_ECON_PRC_FILIAL eo ON fo.CD_EMP = eo.CD_EMP
                                                                                            AND fo.CD_FILIAL = eo.CD_FILIAL
                                                    INNER JOIN PRC_FILIAL fd ON b.CD_EMP = fd.CD_EMP
                                                                                AND b.CD_FILIAL_DEST = fd.CD_FILIAL
                                                    INNER JOIN PRC_GRP_ECON_PRC_FILIAL ed ON fd.CD_EMP = ed.CD_EMP
                                                                                            AND fd.CD_FILIAL = ed.CD_FILIAL
                                                    INNER JOIN PRC_FILIAL_RC_CLI cd ON fd.CD_EMP = cd.CD_EMP
                                                                                    AND fd.CD_FILIAL = cd.CD_FILIAL
																					 										
													INNER JOIN EST_EXCESSO_MAQ C ON  C.CD_EXCESSO_MAQ = @CD_MAQUINA
										    WHERE     B.VLR_TOT_PROD > = C.VLR_LIMITE_TRANSF																					


                                        -------------------------------------------- INSERE OS ITENS DO PEDIDO ----------------------------------------------

                                        IF EXISTS(SELECT TOP 1 CD_EMP
                                            FROM EST_PED_VD
                                            WHERE CD_EMP = @CD_EMP
                                                  AND CD_FILIAL = @FILIAL_ORIG
                                                  AND CD_PED = @CD_PED)
                                            BEGIN
                                                PRINT 'Grava os itens do pedido  - ' + CONVERT(VARCHAR, GETDATE(), 108);
                                                INSERT INTO EST_PED_VD_IT(CD_EMP, CD_FILIAL, CD_PED, CD_PROD, QT_IT, VLR_IT, VLR_DESC, 
																			 QT_EST_ANT, PERC_IPI, PERC_DESC, VLR_ICMS_SUBS_FUT, VLR_PROD_PED, VLR_SUFRAMA, ORD_GRAVA, 
																			 PERC_DESC_CTR, PERC_COMI, PERC_COMI_CTR, VALIDADE, CD_TRIB, QT_SOL, CD_BENEF)
                                                SELECT @CD_EMP, 
                                                        @FILIAL_ORIG, 
                                                        @CD_PED, 
                                                        b.CD_PROD, 
                                                        b.QTDE_ATEND, 
                                                        b.VLR_CUSTO, 
                                                        VLR_DESC = 0, 
                                                        QT_EST_ANT = 0, 
                                                        PERC_IPI = 0, 
                                                        PERC_DESC = 0, 
                                                        VLR_ICMS_SUBS_FUT = 0, 
                                                        VLR_PROD_PED = 0, 
                                                        VLR_SUFRAMA = 0, 
                                                        ORD_GRAVA = 0, 
                                                        PERC_DESC_CTR = 0, 
                                                        PERC_COMI = 0, 
                                                        PERC_COMI_CTR = 0, 
                                                        VALIDADE = 0, 
                                                        CD_TRIB = 0, 
                                                        b.QTDE_ATEND, 
                                                        t.CD_BENEF
                                                FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                                    INNER JOIN #RsItem t ON b.CD_EMP = t.CD_EMP
                                                                            AND b.CD_FILIAL_ORIG = t.CD_FILIAL_ORIG
                                                                            AND b.CD_PROD = t.CD_PROD
                                                WHERE b.QTDE_ATEND > 0
                                                        AND b.CD_EXCESSO_MAQ = @CD_MAQUINA;

                                                INSERT INTO EST_PED_VD_IT_TRILHO_AUDIT(CD_EMP,  CD_FILIAL, CD_PED, CD_PROD, 
																							QT_IT, QT_SOL, DT_CAD, CD_MAQ)
                                                SELECT @CD_EMP, 
                                                        @FILIAL_ORIG, 
                                                        @CD_PED, 
                                                        CD_PROD, 
                                                        QT_IT, 
                                                        QT_SOL, 
                                                        GETDATE(), 
                                                        CONVERT(VARCHAR(10), @CD_MAQUINA) CD_MAQ
                                                FROM EST_PED_VD_IT
                                                WHERE CD_EMP = @CD_EMP
                                                        AND CD_FILIAL = @FILIAL_ORIG
                                                        AND CD_PED = @CD_PED;
                                            END;
                                    END;
                                    ELSE -- RESSUPRIMENTO
                                    BEGIN

                                        ------------------------------- RETORNA O CODIGO DO PEDIDO A SER INSERIDO -------------------------------------------
                                        SET @CD_PED = ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_TRANSF WITH(XLOCK) WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @FILIAL_ORIG), 0) + 1;

                                        --------------------------------------INSERE O CABECALHO DA VENDA ---------------------------------------------------
                                        --Inserindo itens para abatimento posterior
                                        PRINT 'Limpando a tabela temporaria #RsItem ' + CONVERT(VARCHAR, GETDATE(), 108);
                                        TRUNCATE TABLE #RsItem; --Limpando a tabela temporaria

                                        INSERT INTO #RsItem
                                        SELECT @CD_EMP, 
                                                @FILIAL_DEST, 
                                                @FILIAL_ORIG, 
                                                b.CD_PROD, 
                                                b.QTDE_ATEND
                                        FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                            INNER JOIN EST_PROD P ON b.CD_EMP = p.CD_EMP
                                                                        AND b.CD_PROD = p.CD_PROD
                                        WHERE b.QTDE_ATEND > 0
                                                AND b.CD_EXCESSO_MAQ = @CD_MAQUINA
                                        ORDER BY p.DS_PROD;

                                        IF @@ROWCOUNT = 0 --PULA PARA PROXIMO PEDIDO
                                            BEGIN
                                                SET @FLAG_QUEBRA = 0;
                                                BREAK;
                                            END;
                                        --Fim
                                        ---------------------------------------- C A B E C A L H O   D O  R E S S U P R I M E N T O ---------------------------------------
                                        PRINT 'INSERT 19 ' + CONVERT(VARCHAR, GETDATE(), 108);
                                        ;WITH BASE2
                                             AS (SELECT b.CD_EMP, 
                                                        b.CD_FILIAL_ORIG, 
                                                        b.CD_FILIAL_DEST, 
                                                        VLR_TOT_PROD = SUM(b.QTDE_ATEND * b.VLR_CUSTO)
                                                 FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                                      INNER JOIN #RsItem t ON b.CD_EMP = t.CD_EMP
                                                                              AND b.CD_FILIAL_ORIG = t.CD_FILIAL_ORIG
                                                                              AND b.CD_PROD = t.CD_PROD
                                                 WHERE b.CD_EXCESSO_MAQ = @CD_MAQUINA
                                                 GROUP BY b.CD_EMP, 
                                                          b.CD_FILIAL_ORIG, 
                                                          b.CD_FILIAL_DEST)
                                            INSERT INTO EST_PROD_TRANSF(CD_EMP, CD_FILIAL, CD_CTR, TP_TRANSF, CD_FIL_ORIG, CD_FIL_DEST, DT_TRANSF, DT_ENTR, STS_TRANSF, DT_CAD, CD_USU)
                                            SELECT CD_EMP = @CD_EMP, 
                                                    CD_FILIAL = @FILIAL_ORIG, 
                                                    CD_PED = @CD_PED, 
                                                    1, 
                                                    @FILIAL_ORIG, 
                                                    CD_FILIAL_DEST, 
                                                    @DT_HOJE, 
                                                    @DT_HOJE, 
                                                    0, 
                                                    @DT_HOJE, 
                                                    1
                                            FROM BASE2 b;

                                        ---------------------------------------- I T E N S   D O  R E S S U P R I M E N T O ---------------------------------------
                                        PRINT 'INSERT 20 ' + CONVERT(VARCHAR, GETDATE(), 108);
                                        INSERT INTO EST_PROD_TRANSF_IT(CD_EMP, CD_FILIAL, CD_CTR, CD_PROD, QT_SOL, QT_AT, VLR_CUSTO, QT_EST_RES, QT_MEDIAF, QT_EMAX, QT_ESEG, FLAG_RATEIO, QT_EST_DEPO_RES)
                                        SELECT @CD_EMP, 
                                                @FILIAL_ORIG, 
                                                @CD_PED, 
                                                b.CD_PROD, 
                                                b.QTDE_ATEND, 
                                                0, 
                                                b.VLR_CUSTO, 
                                                0, 
                                                b.MEDIAF, 
                                                b.EMAX / 30. * b.MEDIAF, 
                                                b.ESEG / 30. * b.MEDIAF, 
                                                0, 
                                                0
                                        FROM UFD_TRILHO_EXCESSO(@CD_EMP, @FILIAL_ORIG, @FILIAL_DEST, 0) b
                                            INNER JOIN #RsItem t ON b.CD_EMP = t.CD_EMP
                                                                    AND b.CD_FILIAL_ORIG = t.CD_FILIAL_ORIG
                                                                    AND b.CD_PROD = t.CD_PROD
                                        WHERE b.QTDE_ATEND > 0
                                                AND b.CD_EXCESSO_MAQ = @CD_MAQUINA;

                                        DELETE FROM EST_PROD_TRANSF_IT
                                        WHERE CD_EMP = @CD_EMP
                                              AND CD_FILIAL = @FILIAL_ORIG
                                              AND QT_SOL < 1
                                              AND CD_CTR = @CD_PED;
                                    END;

                                -------------------------------------------------- ATUALIZA A TABELA DE NECESSIDADES -------------------------------
                                PRINT 'Atualiza a tabela de necessidades - Linha 560 ' + CONVERT(VARCHAR, GETDATE(), 108);
                                UPDATE n
                                  SET 
                                      n.NECESSIDADE = (n.NECESSIDADE - b.QTDE_PROD), 
                                      NECESSIDADE_FACEAMENTO = 0, 
                                      NECESSIDADE_FINANCIADO = 0, 
                                      NECESSIDADE_LIMITADOR = 0
                                FROM TRILHO_PROD_NECESSIDADE n
                                     INNER JOIN #RsItem b ON n.CD_EMP = b.CD_EMP
                                                             AND n.CD_FILIAL = b.CD_FILIAL_DEST
                                                             AND n.CD_PROD = b.CD_PROD
                                WHERE n.DT_MOV = (CASE
                                                      WHEN @TP_PED = 0
                                                      THEN @DT_HOJE
                                                      ELSE @DT_HOJE - @DIAS_RES_ACRESCENTAR
                                                  END)
                                      AND n.CD_EMP = @CD_EMP
                                      AND n.CD_FILIAL = @FILIAL_DEST;

                                -------------------------------------------------- ATUALIZA A TABELA DE EXCESSO -------------------------------
                                PRINT 'Atualiza a tabela de excesso - linha 580 - ' + CONVERT(VARCHAR, GETDATE(), 108);
                                UPDATE e
                                  SET 
                                      e.EXCESSO = (e.EXCESSO - b.QTDE_PROD)
                                FROM TRILHO_MAQ_EXCESSO e
                                     INNER JOIN #RsItem b ON e.CD_EMP = b.CD_EMP
                                                             AND e.CD_PROD = b.CD_PROD
                                WHERE e.DT_MOV = (CASE WHEN @TP_PED = 0 THEN @DT_HOJE
                                                      ELSE @DT_HOJE - @DIAS_RES_ACRESCENTAR
                                                  END)
                                      AND e.CD_EMP = @CD_EMP
                                      AND e.CD_FILIAL = @FILIAL_ORIG
                                      AND b.CD_FILIAL_ORIG = @FILIAL_ORIG;
                            END;

                        -------------------------------------------------- GRAVA AS FILIAIS QUE JA FORAM UTILIZADAS -------------------------------------------------
                        PRINT 'Grava as filiais que ja foram utilizadas - Linha 596 ' + CONVERT(VARCHAR, GETDATE(), 108);
                        INSERT INTO @combinacaoRealizada VALUES (@FILIAL_ORIG, @FILIAL_DEST);
						
                        FETCH NEXT FROM cOrigemDest INTO  @FILIAL_ORIG, @FILIAL_DEST, @VLR_ATEND;                        
                    END;
										
				CLOSE cOrigemDest;
				DEALLOCATE cOrigemDest;

                FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_DEST, @CD_AGENDA, @CD_MAQUINA;
            END;

        CLOSE cursorTrilhos;
        DEALLOCATE cursorTrilhos;
    END;